module.exports = {
  create: (context) => ({
    ImportDefaultSpecifier: (node) => {
      if (node.local.name === 'React') {
        context.report({
          message: 'Do not import React, use import destructuring instead',
          node,
        });
      }
    },
    TSQualifiedName: (node) => {
      if (node.left.name === 'React') {
        context.report({
          message:
            'Do not use React qualifier, use import destructuring instead',
          node,
        });
      }
    },
  }),
};
