module.exports = {
  create: (context) => ({
    ImportDeclaration: (node) => {
      const rollupPackages = context.options[0];
      if (rollupPackages.includes(node.source.value)) {
        context.report({
          message: `Do not import the ${node.source.value} rollup package in other packages. Instead import from the specific sub-package.`,
          node,
        });
      }
    },
  }),
};
