module.exports = {
  create: (context) => ({
    JSXIdentifier: (node) => {
      if (node.name === 'elementCount') {
        const { parent: openingTag, value } = node.parent;
        if (
          openingTag.name.name.endsWith('Nav') &&
          value &&
          value.type === 'JSXExpressionContainer' &&
          value.expression.type === 'Literal' &&
          value.expression.value === 1
        ) {
          context.report({
            fix: (fixer) => {
              // relies on prettier integration to clean up spacing after fixes
              const fixes = [];

              // remove element count
              fixes.push(fixer.remove(node.parent));

              // convert nav area node
              fixes.push(fixer.replaceText(openingTag.name, 'NodeNav'));
              const closingTag = openingTag.parent.closingElement;
              if (closingTag) {
                fixes.push(fixer.replaceText(closingTag.name, 'NodeNav'));
              }

              // get import info
              const navVariable = context
                .getScope()
                .references.find(
                  (ref) => ref.identifier.name === openingTag.name.name,
                ).resolved;
              const navImportIdentifier = navVariable.identifiers[0];
              const hasNodeNavImport =
                navImportIdentifier.parent.parent.specifiers.some(
                  (specifier) => specifier.imported.name === 'NodeNav',
                );
              const originalHasOtherUses = navVariable.references.length > 1;

              if (!hasNodeNavImport) {
                // add NodeNav import if it missing
                if (!originalHasOtherUses) {
                  // if no other usages of original Nav type, replace import
                  fixes.push(fixer.replaceText(navImportIdentifier, 'NodeNav'));
                } else {
                  // otherwise, append NodeNav import
                  fixes.push(
                    fixer.insertTextAfter(navImportIdentifier, ', NodeNav'),
                  );
                }
              } else if (!originalHasOtherUses) {
                // remove original Nav import including trailing comma
                const [start, end] = navImportIdentifier.range;
                fixes.push(fixer.removeRange([start, end + 1]));
              }

              return fixes;
            },
            message:
              'Use NodeNav for nav areas with only a single focusable child',
            node,
          });
        }
      }
    },
  }),
};
