module.exports = {
  create: (context) => ({
    ImportDeclaration: (node) => {
      const rollupPackages = context.options[0];

      rollupPackages.forEach((rollupPackage) => {
        if (
          node.source.value.startsWith(rollupPackage) &&
          node.source.value !== rollupPackage
        ) {
          context.report({
            fix: (fixer) =>
              fixer.replaceText(node.source, `'${rollupPackage}'`),
            message: `Do not import the ${rollupPackage} sub-packages in apps. Instead import from the ${rollupPackage} rollup package.`,
            node,
          });
        }
      });
    },
  }),
};
