module.exports = {
  create: (context) => ({
    Identifier: (node) => {
      if (node.name === 'useState') {
        const declaration = node.parent.parent;

        if (declaration.type === 'VariableDeclarator') {
          const vars = declaration.id;

          if (
            vars.type === 'ArrayPattern' &&
            vars.elements &&
            vars.elements.length === 1
          ) {
            context.report({
              message:
                'Prefer useConst (from tachyon-utils-react) for unchanging state',
              node: declaration,
            });
          }
        }
      }
    },
  }),
};
