import { createMountWrapperFactory } from 'tachyon-test-utils';
import { createConsoleReportEvent } from '../reportEvent';
import { EventReporterRoot } from './EventReporterRoot';
import { useReportEvent } from './useReportEvent';
import type { ReportEventProps } from './withReportEvent';
import { withReportEvent } from './withReportEvent';

jest.mock('../reportEvent', () => ({
  ...jest.requireActual('../reportEvent'),
  createConsoleReportEvent: jest.fn(),
}));
const mockCreateConsoleReportEvent = createConsoleReportEvent as jest.Mock;

describe('Event Reporter', () => {
  const setup = createMountWrapperFactory(EventReporterRoot);

  const event = { event: 'test', properties: { properties: true } };

  it('provides a working reportEvent to children using withReportEvent', () => {
    const mockReportEvent = jest.fn();
    mockCreateConsoleReportEvent.mockImplementationOnce(() => mockReportEvent);

    const TestComponent = withReportEvent(
      ({ reportEvent }: ReportEventProps) => {
        reportEvent(event);
        return null;
      },
    );

    setup({ children: <TestComponent /> });
    expect(mockReportEvent).toHaveBeenCalledWith(event);
  });

  it('provides a working reportEvent to children using useReportEvent', () => {
    const mockReportEvent = jest.fn();
    mockCreateConsoleReportEvent.mockImplementationOnce(() => mockReportEvent);

    const TestComponent = () => {
      const reportEvent = useReportEvent();
      reportEvent(event);
      return null;
    };

    setup({ children: <TestComponent /> });
    expect(mockReportEvent).toHaveBeenCalledWith(event);
  });
});
