import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import type { ReportEvent } from '../types';
import { useReportEvent } from './useReportEvent';

/**
 * Props for mixing into components wrapped by withEventReporter.
 */
export interface ReportEventProps {
  reportEvent: ReportEvent;
}

/**
 * The withReportEvent HOC adds the `reportEvent` prop to the wrapper components
 * component's props. Pair with `ReportEventProps`.
 */
export function withReportEvent<P extends ReportEventProps>(
  Comp: ComponentType<P>,
): FC<Omit<P, keyof ReportEventProps>> {
  const Wrapper: FC<Omit<P, keyof ReportEventProps>> = (props) => {
    const reportEvent = useReportEvent();

    const newProps = {
      ...props,
      reportEvent,
    } as P;

    return <Comp {...newProps} />;
  };

  Wrapper.displayName = `EventReporter(${getComponentName(Comp)})`;

  return Wrapper;
}
