import type { TwitchEvent, TwitchEventProperties } from 'tachyon-type-library';
import { pick } from 'tachyon-utils-stdlib';

export type FlumeifyEventOpts<EventType extends TwitchEvent = TwitchEvent> = {
  allowedProperties: string[];
  event: EventType;
};

export function flumeifyEvent<EventType extends TwitchEvent = TwitchEvent>({
  allowedProperties,
  event: { event, properties },
}: FlumeifyEventOpts<EventType>): TwitchEvent {
  return {
    event,
    properties:
      properties &&
      pick<TwitchEventProperties, TwitchEventProperties>(
        properties,
        allowedProperties,
      ),
  };
}
