import { flumeifyEvent } from '.';

describe(flumeifyEvent, () => {
  const event = 'event';
  const allowedProperties = ['allowed'];

  it('filters disallowed properties from event', () => {
    const properties = { allowed: true };

    expect(
      flumeifyEvent({
        allowedProperties,
        event: { event, properties: { ...properties, disallowed: true } },
      }),
    ).toEqual({ event, properties });
  });

  it('does not error if properties not present on event', () => {
    expect(() =>
      flumeifyEvent({ allowedProperties: [], event: { event } }),
    ).not.toThrow();
  });
});
