import { logger } from 'tachyon-logger';
import type { TwitchEvent } from 'tachyon-type-library';
import { unspadeifyEvents } from 'tachyon-utils-crypto';
import { errorMessageFromCatch } from 'tachyon-utils-stdlib';

/**
 * Function for safely attempting to log payloads that might be flume events
 * received on the server
 */
export function logFlume(maybeFlume: string): void {
  try {
    const events = unspadeifyEvents<TwitchEvent>(maybeFlume);

    events.forEach((event) => {
      if (event.event) {
        logger.log({
          category: 'logFlume',
          context: event.properties,
          message: event.event,
          package: 'tachyon-event-reporter',
        });
      }
    });
  } catch (e) {
    logger.log({
      category: 'logFlume',
      context: { error: errorMessageFromCatch(e) },
      message: 'Error logging flume data',
      package: 'tachyon-event-reporter',
    });
  }
}
