import { logger } from 'tachyon-logger';
import type { TwitchEvent } from 'tachyon-type-library';
import type { ReportEvent } from '../../types';

// istanbul ignore next: trivial
/**
 * Console reportEvent reports all events to the console at the `debug` level.
 *
 * **Sending Extended Events**
 * Console reportEvent defaults to events of type TwitchEvent. However, any
 * event that extends TwitchEvent can be sent through console reportEvent.
 */
export function createConsoleReportEvent<
  EventType extends TwitchEvent = TwitchEvent,
>(): ReportEvent<EventType> {
  return (event: EventType) =>
    logger.debug({
      category: 'consoleReportEvent',
      context: event.properties,
      // we don't send these to sentry because event properties can have PII
      localOnly: true,
      message: event.event,
      package: 'tachyon-event-reporter',
    });
}
