import { flumeifyEvent } from '../../flumeify';
import { createSpadeReportEvent } from '../createSpadeReportEvent';
import { createFlumeReportEvent } from '.';

jest.mock('../../flumeify', () => ({ flumeifyEvent: jest.fn() }));
const mockFlumeifyEvent = flumeifyEvent as jest.Mock;

jest.mock('../createSpadeReportEvent', () => ({
  createSpadeReportEvent: jest.fn(),
}));
const mockCreateSpadeReportEvent = createSpadeReportEvent as jest.Mock;

describe(createFlumeReportEvent, () => {
  const allowedEvents = ['chainsaw'];
  const allowedProperties = ['lumberjack'];
  const batchWindowMs = 100;
  const flumeUrl = '//flume';

  it('flumeifies allowed events and reports', () => {
    const spadeReportEvent = jest.fn();
    mockCreateSpadeReportEvent.mockImplementationOnce(() => spadeReportEvent);
    const flumeEvent = { flumeEvent: true } as any;
    mockFlumeifyEvent.mockImplementationOnce(() => flumeEvent);

    const event = { event: allowedEvents[0], rawEvent: true } as any;

    const flumeReportEvent = createFlumeReportEvent({
      allowedEvents,
      allowedProperties,
      batchWindowMs,
      flumeUrl,
    });
    expect(mockCreateSpadeReportEvent).toHaveBeenCalledWith({
      batchWindowMs,
      spadeUrl: flumeUrl,
    });

    flumeReportEvent(event);
    expect(mockFlumeifyEvent).toHaveBeenCalledWith({
      allowedProperties,
      event,
    });
    expect(spadeReportEvent).toHaveBeenCalledWith(flumeEvent);
  });

  it('does not report non-allowed events', () => {
    const spadeReportEvent = jest.fn();
    mockCreateSpadeReportEvent.mockImplementationOnce(() => spadeReportEvent);
    const flumeEvent = { flumeEvent: true } as any;
    mockFlumeifyEvent.mockImplementationOnce(() => flumeEvent);

    const event = { event: 'ax', rawEvent: true } as any;

    const flumeReportEvent = createFlumeReportEvent({
      allowedEvents,
      allowedProperties,
      batchWindowMs,
      flumeUrl,
    });
    expect(mockCreateSpadeReportEvent).toHaveBeenCalledWith({
      batchWindowMs,
      spadeUrl: flumeUrl,
    });

    flumeReportEvent(event);
    expect(mockFlumeifyEvent).not.toHaveBeenCalled();
    expect(spadeReportEvent).not.toHaveBeenCalled();
  });
});
