import type { TwitchEvent } from 'tachyon-type-library';
import type { ReportEvent } from '../../types';

/**
 * Multi-reportEvent takes a list of reportEvent functions upon creation and
 * dispatches event reports to each reportEvent function sequentially.
 *
 * **Sending Extended Events**
 * Multi-reportEvent defaults to events of type TwitchEvent. However, any
 * event that extends TwitchEvent can be sent through multi-reportEvent.
 */
export function createMultiReportEvent<
  EventType extends TwitchEvent = TwitchEvent,
>(reportEventFuncs: ReportEvent<EventType>[]): ReportEvent<EventType> {
  return (event) => reportEventFuncs.forEach((r) => r(event));
}
