import type { ReportEvent } from '../../types';
import { createMultiReportEvent } from '.';

describe(createMultiReportEvent, () => {
  const message = { event: 'fake', properties: { data: 'ohai' } };

  function createDummyReportEvent(): ReportEvent {
    return jest.fn();
  }

  it('reports events to a reportEvent function', () => {
    const dummy = createDummyReportEvent();
    const multi = createMultiReportEvent([dummy]);
    multi(message);
    expect(dummy).toHaveBeenCalled();
    expect(dummy).toHaveBeenCalledWith(message);
  });

  it('includes options in when invoking a reportEvent function', () => {
    const dummy = createDummyReportEvent();
    const multi = createMultiReportEvent([dummy]);
    multi(message);
    expect(dummy).toHaveBeenCalled();
    expect(dummy).toHaveBeenCalledWith(message);
  });

  it('reports events to multiple reportEvent functions', () => {
    const dummies = [createDummyReportEvent(), createDummyReportEvent()];
    const multi = createMultiReportEvent(dummies);
    multi(message);
    dummies.forEach((dummy) => {
      expect(dummy).toHaveBeenCalledWith(message);
    });
  });

  it('does not fail when there are no reportEvent functions', () => {
    const multi = createMultiReportEvent([]);
    expect(() => multi(message)).not.toThrow();
  });
});
