import type { TwitchEvent } from 'tachyon-type-library';
import type { ReportEvent } from '../../types';
import { createSpadeReportEvent } from '../createSpadeReportEvent';

export const SPADE_ECHO_URL = 'https://spade-echo.internal.justin.tv';

/**
 * Spade Echo reportEvent reports all events to the Spade Echo server which is
 * a useful server provided by DS to help debug Spade event issues.
 *
 * **NOTE**: This _should not_ be used in production environments.
 */
export function createSpadeEchoReportEvent<
  EventType extends TwitchEvent = TwitchEvent,
>(): ReportEvent<EventType> {
  return createSpadeReportEvent({ batchWindowMs: 0, spadeUrl: SPADE_ECHO_URL });
}
