import type { EventTrackerContext } from '../EventTrackerRoot';
import type {
  CustomEventProperties,
  DefaultCustomPayload,
  MinimumCustomPayload,
} from '../event-data';
import { EventType } from '../event-data';

/**
 * Shape of the payload for custom events, omits type
 */
export type CustomEventDataPayload<
  T extends MinimumCustomPayload = DefaultCustomPayload,
> = CustomEventProperties<T>;

export type TrackEvent<T extends MinimumCustomPayload = DefaultCustomPayload> =
  (payload: T) => void;

/**
 * Private function for mapping the payload into proper EventData
 */
export function createTrackEvent<
  T extends MinimumCustomPayload = DefaultCustomPayload,
>({ onEvent }: EventTrackerContext): TrackEvent<T> {
  return (payload: CustomEventDataPayload): void => {
    onEvent({
      event: EventType.Custom,
      properties: {
        ...payload,
      },
    });
  };
}
