import { datatype, lorem } from 'faker';
import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import type { EventTrackerContext } from '../EventTrackerRoot';
import { eventTrackerContext } from '../EventTrackerRoot';
import type { CustomEventProperties } from '../event-data';
import { EventType } from '../event-data';
import { withCustomTracking } from './withCustomTracking';

describe(withCustomTracking, () => {
  const customPayload: CustomEventProperties = {
    alecWasHere: datatype.boolean(),
    andy: lorem.words(),
    bigness: datatype.number(),
    event: 'alec tracker',
  };

  const MockCustomTrackingRenderer: FC<EventTrackerContext> = ({
    children,
    ...ctxProps
  }) => {
    return (
      <eventTrackerContext.Provider children={children} value={ctxProps} />
    );
  };

  const setup = createMountWrapperFactory(MockCustomTrackingRenderer, () => ({
    interactionMedium: '',
    location: undefined,
    onEvent: jest.fn(),
    twitchTracking: {},
  }));

  const TestElement = withCustomTracking(({ trackEvent }) => {
    trackEvent(customPayload);
    return null;
  });

  it('gets custom payload', () => {
    const { props } = setup({ children: <TestElement /> });

    const expectedProperties = { ...customPayload };
    // @ts-expect-error: tests
    delete expectedProperties.event;

    expect(props.onEvent).toHaveBeenCalledWith({
      event: EventType.Custom,
      properties: expect.objectContaining(expectedProperties),
    });
  });
});
