import { useConstCallback } from 'tachyon-utils-react';
import { useEventTrackerContext } from '../EventTrackerRoot';
import type { DefaultCustomPayload, MinimumCustomPayload } from '../event-data';
import type { TrackEvent } from './createTrackEvent';
import { createTrackEvent } from './createTrackEvent';

// istanbul ignore next: trivial
/**
 * useCustomTracking is a hook that returns a `trackEvent` function,
 * allowing the reporting of arbitrary events. The function accepts any keys but
 * reserves `type` for internal use and the field `event` will be used for the
 * event type. The event values must be primitive:
 * string | number | boolean | null | undefined.
 *
 * Frequently used event types should ideally be promoted to their own explicit
 * handling system to ensure proper event shapes.
 */
export function useCustomTracking<
  T extends MinimumCustomPayload = DefaultCustomPayload,
>(): TrackEvent<T> {
  return useConstCallback(createTrackEvent<T>(useEventTrackerContext()));
}
