import type { EventTrackerContext } from '../EventTrackerRoot';
import type { DeviceCodeFlowProperties } from '../event-data';
import { EventType } from '../event-data';

export type TrackDeviceCodeFlow = (payload: DeviceCodeFlowProperties) => void;

// istanbul ignore next: trivial
export function createTrackDeviceCodeFlow({
  onEvent,
}: EventTrackerContext): TrackDeviceCodeFlow {
  return (payload: DeviceCodeFlowProperties): void => {
    onEvent({
      event: EventType.DeviceCodeFlow,
      properties: payload,
    });
  };
}
