import type { Primitive } from 'type-fest';
import type { CommonEventProperties } from './common';
import type { EventType } from './types';

export type MinimumCustomPayload = {
  event: string;
  location?: string;
  time?: number;
};

export type DefaultCustomPayload = MinimumCustomPayload & {
  [key: string]: Primitive;
};

export type CustomEventProperties<
  Obj extends MinimumCustomPayload = DefaultCustomPayload,
> = {
  [Key in keyof Obj]: Key extends keyof MinimumCustomPayload
    ? MinimumCustomPayload[Key]
    : Primitive;
};

/**
 * A free-for-all event type that should only be used as a last resort because
 * you lose any type/shape enforcement; frequently used event types should be
 * added to this package with properly-shaped types to avoid sending bad data
 * in event payloads. Accepts almost any key with primitive-only values.
 * Must contain an `event` key, and may contain `time` (number) and `location`
 * (string) properties.
 */
export type RawCustomEventData = {
  event: EventType.Custom;
  properties: CustomEventProperties;
};

export type ProcessedCustomEventData = {
  event: string;
  properties: CommonEventProperties & Omit<CustomEventProperties, 'event'>;
};
