import type { CommonEventData } from './common';
import type { EventType } from './types';

// Tracking spec: https://docs.google.com/document/d/18Pgu0hiRMHBzI9OlfpkMf4sHryFAdTIKV39Gj662des/edit?usp=sharing

export type DeviceCodeFlowProperties =
  | {
      context: 'blocking' | 'chatting' | 'following';
      flow_state: 'initiated';
    }
  | {
      context: 'manual' | 'qr_code';
      flow_state: 'activated';
    }
  | {
      flow_state:
        | 'abandoned'
        | 'codeRefreshed'
        | 'deactivated'
        | 'displayed'
        | 'invalidated';
    };

/**
 * Data about an device code flow (DCF) event.
 */
export type RawDeviceCodeFlowEventData = {
  event: EventType.DeviceCodeFlow;
  properties: DeviceCodeFlowProperties;
};

export type ProcessedDeviceCodeFlowEventData = CommonEventData &
  RawDeviceCodeFlowEventData;
