import type { ProcessedCustomEventData, RawCustomEventData } from './custom';
import type {
  ProcessedDeviceCodeFlowEventData,
  RawDeviceCodeFlowEventData,
} from './devicecodeflow';
import type {
  ProcessedInteractionEventData,
  RawInteractionEventData,
} from './interaction';
import type {
  ProcessedPageviewEventData,
  RawPageviewEventData,
} from './pageview';

export * from './common';
export * from './custom';
export * from './devicecodeflow';
export * from './interaction';
export * from './pageview';
export * from './types';

/**
 * Union representing all raw / internal event data types.
 */
export type RawEventData =
  | RawCustomEventData
  | RawDeviceCodeFlowEventData
  | RawInteractionEventData
  | RawPageviewEventData;

/**
 * The EventData payloads that will be emitted from the event tracking system.
 * It includes location and time with all event types.
 */
export type ProcessedEventData =
  | ProcessedCustomEventData
  | ProcessedDeviceCodeFlowEventData
  | ProcessedInteractionEventData
  | ProcessedPageviewEventData;
