import type { CommonEventData } from './common';
import type { EventTrackerVODType, EventType } from './types';

/**
 * Pageview data as seen in blueprint: https://blueprint.di.xarth.tv/#/schema/pageview
 */
export type PageviewEventProperties = {
  /**
   * Name of the channel on page, if any.
   */
  channel: string | undefined;
  /**
   * ID of the channel on page, if any.
   */
  channel_id: number | undefined;
  /**
   * Boolean indicating if the pageview occurred in an offline setting. The definition of offline is determined by the client application.
   */
  client_offline: boolean | undefined;
  /**
   * Twitch tracking content value
   */
  content: string | undefined;
  /**
   * Twitch tracking email notification id that triggered the pageview, if applicable.
   */
  email_id: string | undefined;
  /**
   * Name of the game on page, if any.
   */
  game: string | undefined;
  /**
   * Null for all non-channel pages, true/false indicates if the video page has
   * live video playing.
   */
  is_live: boolean | undefined;
  /**
   * The current app location when a pageview happens. This should map to the
   * locations defined in data science.
   */
  location: string | undefined;
  /**
   * Twitch tracking medium value
   */
  medium: string | undefined;
  /**
   * ID of the VOD on page, if any.
   */
  vod_id: string | undefined;
  /**
   * Type of VOD on page, if any.
   */
  vod_type: EventTrackerVODType | undefined;
};

/**
 * Data about a pageview event.
 */
export type RawPageviewEventData = {
  event: EventType.Pageview;
  properties: PageviewEventProperties;
};

export type ProcessedPageviewEventData = CommonEventData & RawPageviewEventData;
