export enum EventTrackerVODType {
  Archive = 'archive',
  Clip = 'clip',
  Highlight = 'highlight',
  PastPremiere = 'past_premiere',
  PremiereUpload = 'premiere_upload',
  Upload = 'upload',
}

export type ContentMode = 'clip' | 'live' | 'vod' | 'vodcast';

/**
 * List of the different event types that might be emitted for handling.
 */
export enum EventType {
  Custom = 'custom',
  DeviceCodeFlow = 'device_code_flow',
  Interaction = 'ui_interaction',
  Pageview = 'pageview',
}

export enum DeviceOrientation {
  Landscape = 'landscape',
  Portrait = 'portrait',
  Server = 'server',
}
