import type { FC } from 'react';
import { useMemo } from 'react';
import {
  eventTrackerContext,
  useEventTrackerContext,
} from '../EventTrackerRoot';

export type ExtendInteractionMediumProps = {
  /**
   * A string (or a function that returns a string) to append to the medium.
   */
  value: string | (() => string);
};

/**
 * The ExtendInteractionMedium extends the current interactionMedium string by
 * the extension value passed in. The new interactionMedium for the subtree
 * below this component will be `originalMedium.mediumExtension`.
 */
export const ExtendInteractionMedium: FC<ExtendInteractionMediumProps> = ({
  children,
  value,
}) => {
  const {
    interactionMedium: parentMedium,
    location,
    onEvent,
    twitchTracking,
  } = useEventTrackerContext();

  const newMedium = typeof value === 'function' ? value() : value;

  const ctx = useMemo(
    () => ({
      interactionMedium: `${parentMedium}.${newMedium}`,
      location,
      onEvent,
      twitchTracking,
    }),
    [location, newMedium, onEvent, parentMedium, twitchTracking],
  );

  return (
    <eventTrackerContext.Provider value={ctx}>
      {children}
    </eventTrackerContext.Provider>
  );
};

ExtendInteractionMedium.displayName = 'ExtendInteractionMedium';
