import type { EventTrackerContext } from '../EventTrackerRoot';
import type { InteractionType } from '../event-data';
import { EventType } from '../event-data';

/**
 * Shape of the payload for interaction events
 */
export type InteractionDataPayload = {
  interaction: InteractionType;
  interactionContent: string;
  interactionTargetPath?: string | undefined;
};

export type TrackInteraction = (payload: InteractionDataPayload) => void;

/**
 * Private function for mapping the payload into proper EventData
 */
export function createTrackInteraction({
  interactionMedium,
  onEvent,
}: EventTrackerContext): TrackInteraction {
  return (payload: InteractionDataPayload): void => {
    onEvent({
      event: EventType.Interaction,
      properties: {
        interaction: payload.interaction,
        interaction_content: payload.interactionContent,
        interaction_medium: interactionMedium,
        interaction_target_path: payload.interactionTargetPath,
      },
    });
  };
}
