import { useEventTrackerContext } from '../EventTrackerRoot';
import type { TrackInteraction } from './createTrackInteraction';
import { createTrackInteraction } from './createTrackInteraction';

// istanbul ignore next: trivial
/**
 * useInteractionTracking is a hook that returns a `trackInteraction` function,
 * allowing the reporting of interaction events. The function expects a
 * `InteractionDataPayload`; `interactionContent` and `interactionType` are the
 * only mandatory keys for the event shape, but `interactionTargetPath` can be
 * used to indicate the destination of things like links.
 */
export function useInteractionTracking(): TrackInteraction {
  return createTrackInteraction(useEventTrackerContext());
}
