import type {
  ProcessedEventData,
  RawEventData,
  StaticProperties,
} from '../event-data';
import { EventType } from '../event-data';
import type { GetDynamicPropertiesOpts } from '../utils';
import { getDynamicProperties } from '../utils';

type ProcessEventOpts = GetDynamicPropertiesOpts & {
  data: RawEventData;
  staticProperties: StaticProperties;
};

export function processEvent({
  data,
  getUserTracking,
  location,
  page_session_id,
  staticProperties,
}: ProcessEventOpts): ProcessedEventData {
  const properties = {
    ...data.properties,
    ...staticProperties,
    ...getDynamicProperties({
      getUserTracking,
      location,
      page_session_id,
    }),
  };

  switch (data.event) {
    case EventType.Custom: {
      // @ts-expect-error: properties.event is at the top-level
      delete properties.event;
      const { event, ...customData } = data.properties;

      return {
        event,
        properties: {
          ...properties,
          // Allow any static / dynamic properties to be overriden by event data
          ...customData,
        },
      };
    }
    case EventType.Interaction:
    case EventType.DeviceCodeFlow:
      return {
        event: data.event,
        properties,
      };
    case EventType.Pageview:
      return {
        event: data.event,
        // Allow location to be overriden by event data
        properties: {
          ...properties,
          location: properties.location ?? data.properties.location,
        },
      };
    /* istanbul ignore next: not testable */
    default: {
      const exhaust: never = data;
      return exhaust;
    }
  }
}
