import Bowser from 'bowser';
import { BOWSER_USER_AGENT_FALLBACK } from 'tachyon-utils-twitch';
import type { BrowserAndOsInfo } from '../../event-data';

const MAJOR_MINOR_REGEX = /^(\d+\.\d+)/;

/**
 * Generates browser and OS info in the format expected by Data Science. If
 * userAgent is not provided (such as in a server environment), this defaults to
 * using `unknown` which will generate `unkown` values for all keys.
 */
export function getBrowserAndOsInfo(userAgent: string): BrowserAndOsInfo {
  const agentInfo = Bowser.getParser(userAgent || BOWSER_USER_AGENT_FALLBACK);
  const { name: osName, version: osVersion } = agentInfo.getOS();
  const { name: browserName, version: browserVersion } = agentInfo.getBrowser();

  return {
    browser_family: browserName ? browserName.toLowerCase() : 'unknown',
    browser_version:
      browserVersion && MAJOR_MINOR_REGEX.test(browserVersion)
        ? browserVersion.match(MAJOR_MINOR_REGEX)![0] // eslint-disable-line @typescript-eslint/no-non-null-assertion
        : 'unknown',
    os_name: osName || 'unknown',
    os_version: osVersion || 'unknown',
  };
}
