import Bowser from 'bowser';
import { BOWSER_USER_AGENT_FALLBACK } from 'tachyon-utils-twitch';
import { getBrowserAndOsInfo } from '.';

jest.mock('bowser', () => ({ getParser: jest.fn() }));
const mockBowserGetParser = Bowser.getParser as jest.Mock;

describe(getBrowserAndOsInfo, () => {
  it('formats valid data from Bowser', () => {
    const os_name = 'macOS';
    const os_version = '10.15.7';
    mockBowserGetParser.mockImplementationOnce(() => ({
      getBrowser: () => ({ name: 'Safari', version: '14.1.0' }),
      getOS: () => ({ name: os_name, version: os_version }),
    }));

    expect(getBrowserAndOsInfo('')).toEqual({
      browser_family: 'safari',
      browser_version: '14.1',
      os_name,
      os_version,
    });
  });

  it('returns fallbacks when parsing fails', () => {
    mockBowserGetParser.mockImplementationOnce(() => ({
      getBrowser: () => ({}),
      getOS: () => ({}),
    }));

    expect(getBrowserAndOsInfo('')).toEqual({
      browser_family: 'unknown',
      browser_version: 'unknown',
      os_name: 'unknown',
      os_version: 'unknown',
    });
  });

  it('converts empty-string userAgent parameter to safe input and handles non-semver browser version', () => {
    mockBowserGetParser.mockImplementationOnce(() => ({
      getBrowser: () => ({ version: 'version' }),
      getOS: () => ({}),
    }));

    expect(getBrowserAndOsInfo('')).toEqual({
      browser_family: 'unknown',
      browser_version: 'unknown',
      os_name: 'unknown',
      os_version: 'unknown',
    });
    expect(mockBowserGetParser).toHaveBeenCalledWith(
      BOWSER_USER_AGENT_FALLBACK,
    );
  });
});
