import { isBrowser } from 'tachyon-utils-stdlib';
import { DeviceOrientation } from '../../event-data';
import { getDeviceOrientation } from '.';

jest.mock('tachyon-utils-stdlib', () => ({
  ...jest.requireActual('tachyon-utils-stdlib'),
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;

describe(getDeviceOrientation, () => {
  it('returns safely on the server', () => {
    mockIsBrowser.mockImplementationOnce(() => false);
    expect(getDeviceOrientation()).toEqual(DeviceOrientation.Server);
  });

  describe('via window.screen.orientation', () => {
    interface OrientationTestCase {
      expected: DeviceOrientation;
      type: OrientationType;
    }
    const testCases: OrientationTestCase[] = [
      { expected: DeviceOrientation.Landscape, type: 'landscape-primary' },
      { expected: DeviceOrientation.Landscape, type: 'landscape-secondary' },
      { expected: DeviceOrientation.Portrait, type: 'portrait-primary' },
      { expected: DeviceOrientation.Portrait, type: 'portrait-secondary' },
    ];

    testCases.forEach(({ expected, type }) => {
      it(`returns ${expected} for ${type}`, () => {
        mockIsBrowser.mockImplementationOnce(() => true);
        (window.screen.orientation as any) = { type };
        expect(getDeviceOrientation()).toEqual(expected);
      });
    });

    afterAll(() => {
      (window.screen.orientation as any) = undefined;
    });
  });

  describe('via window.orientation', () => {
    const testCases = [
      { expected: DeviceOrientation.Portrait, orientation: 0 },
      { expected: DeviceOrientation.Portrait, orientation: 180 },
      { expected: DeviceOrientation.Landscape, orientation: 90 },
      { expected: DeviceOrientation.Landscape, orientation: -90 },
    ];

    testCases.forEach(({ expected, orientation }) => {
      it(`returns ${expected} for ${orientation}`, () => {
        mockIsBrowser.mockImplementationOnce(() => true);
        (window.orientation as any) = orientation;
        expect(getDeviceOrientation()).toEqual(expected);
      });
    });

    afterAll(() => {
      (window.orientation as any) = undefined;
    });
  });
});
