export function getReferrerHost(
  referrer: string = window.document.referrer,
): string {
  try {
    return new URL(referrer).host;
  } catch (e) {
    return '';
  }
}

export function getReferrerDomain(
  referrer: string = window.document.referrer,
): string {
  const host = getReferrerHost(referrer);

  return host ? (host.match(/([^.]+\.[^.]+)$/) || [])[1] : '';
}
