import { getReferrerDomain, getReferrerHost } from '.';

describe('referrer', () => {
  it('gets referrer host', () => {
    expect(getReferrerHost('https://www.reddit.com/r/overwatch')).toEqual(
      'www.reddit.com',
    );
  });

  it('gets referrer domain', () => {
    expect(getReferrerDomain('https://www.reddit.com/r/overwatch')).toEqual(
      'reddit.com',
    );
  });

  it('does not error when referrer is not set', () => {
    expect(getReferrerHost('not a url')).toEqual('');
    expect(getReferrerDomain('not a url')).toEqual('');
  });
});
