import type { FC } from 'react';
import { ExperimentGroup } from '../experimentInfo';
import { useExperimentGroupIsActive } from './Experiment';

/**
 * The 'treatment' branch of the experiment.
 * Treatment is a child of the `Experiment` component.
 */
export const Treatment: FC = (props) => {
  return useExperimentGroupIsActive(ExperimentGroup.Treatment) ? (
    <>{props.children}</>
  ) : null;
};

Treatment.displayName = 'Treatment';

/**
 * The 'control' branch of the experiment.
 * Control is a child of the `Experiment` component.
 */
export const Control: FC = (props) => {
  return useExperimentGroupIsActive(ExperimentGroup.Control) ? (
    <>{props.children}</>
  ) : null;
};

Control.displayName = 'Control';
