import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Control, Experiment, Treatment } from '../components';
import { MockExperimentControl, MockExperimentTreatment } from '.';

jest.mock('../components', () => ({
  ...jest.requireActual('../components'),
  Experiment: jest.fn(),
}));

const mockExperiment = Experiment as jest.Mock;

const Component: FC = () => (
  <Experiment experimentUUID="foo">
    <Treatment>Treatment</Treatment>
    <Control>Control</Control>
  </Experiment>
);

describe('MockExperiment', () => {
  const setup = createMountWrapperFactory(Component);

  it('MockExperimentControl renders the control path', () => {
    mockExperiment.mockImplementationOnce(MockExperimentControl);

    const { wrapper } = setup();
    expect(wrapper).toIncludeText('Control');
    expect(wrapper).not.toIncludeText('Treatment');
  });

  it('MockExperimentTreatment renders the treatment path', () => {
    mockExperiment.mockImplementationOnce(MockExperimentTreatment);

    const { wrapper } = setup();
    expect(wrapper).toIncludeText('Treatment');
    expect(wrapper).not.toIncludeText('Control');
  });
});
