import type {
  ExperimentBucket,
  ExperimentMetadata,
  ExperimentSlot,
} from '../../experimentInfo';
import { BUCKET_ASSIGNMENT, ExperimentGroup } from '../../experimentInfo';

/**
 * Get the experiment group for the current user.
 *
 * @param metadata Experiment metadata containing weights for each experiment
 *   group that can be used to determine to which group the user belongs.
 * @param bucket The bucket assignment
 * @param slot The experiment slot
 */
export function getExperimentGroup(
  metadata: ExperimentMetadata,
  bucket: ExperimentBucket,
  slot: ExperimentSlot,
): ExperimentGroup {
  const treatmentEnabled = !!metadata.groups.find(
    (group) => group.value === ExperimentGroup.Treatment,
  )?.weight;
  if (!treatmentEnabled) {
    return ExperimentGroup.Control;
  }

  const controlEnabled = !!metadata.groups.find(
    (group) => group.value === ExperimentGroup.Control,
  )?.weight;
  if (!controlEnabled) {
    return ExperimentGroup.Treatment;
  }

  return BUCKET_ASSIGNMENT[bucket][slot];
}
