import type { UserExperimentMetadata } from '../getExperimentGroupsForUser';

/**
 *
 * @param experiments an array of ExperimentData to be transformed
 * into a string to use with the experiment_overrides parameter.
 */
export function getExperimentOverridesQueryParams(
  experiments: UserExperimentMetadata[],
): string {
  return experiments
    .map((experiment: UserExperimentMetadata) => {
      return `${experiment.uuid}=${experiment.group}`;
    })
    .join(',');
}
