import type { UserExperimentMetadata } from '../..';
import { ExperimentGroup } from '../..';
import { getExperimentOverridesQueryParams } from '.';

describe(getExperimentOverridesQueryParams, () => {
  it('correctly builds query params', () => {
    const mockUUID1 = 'foo';
    const mockUUID2 = 'bar';

    const experiments: UserExperimentMetadata[] = [
      {
        group: ExperimentGroup.Control,
        name: 'mobile_web_experiment_1',
        type: 'device_id',
        uuid: mockUUID1,
        version: 1,
      },
      {
        group: ExperimentGroup.Treatment,
        name: 'mobile_web_experiment_2',
        type: 'device_id',
        uuid: mockUUID2,
        version: 1,
      },
    ];

    const experimentOverrides = getExperimentOverridesQueryParams(experiments);
    expect(experimentOverrides).toEqual(
      `${mockUUID1}=${ExperimentGroup.Control},${mockUUID2}=${ExperimentGroup.Treatment}`,
    );
  });
});
