import { parseBucket } from '.';

describe(parseBucket, () => {
  it('normalizes (lowercases) the bucket value', () => {
    expect(parseBucket('F')).toEqual('f');
  });

  it.each(['Q', 'z', 'a,b', undefined, ''])(
    'undefined when invalid bucket %s',
    (invalid) => {
      expect(parseBucket(invalid)).toBeUndefined();
    },
  );
});
