import type {
  ExperimentMetadata,
  ExperimentSlots,
  WeightedExperimentGroup,
} from '../experimentInfo';
import { ExperimentGroup } from '../experimentInfo';
import type {
  ExperimentGroupsForUser,
  UserExperimentMetadata,
} from './getExperimentGroupsForUser';

// istanbul ignore file: test utils

export type GenerateTestExperimentMetadataOpts = {
  control: WeightedExperimentGroup['weight'];
  treatment: WeightedExperimentGroup['weight'];
  uuid: string;
};

/**
 * Helper function to generate an ExperimentMetadata from some weightings and a
 * version.
 *
 * @param param0 The weighting and version for this experiment.
 * @returns An ExperimentsMedatadata object to use for tests.
 */
export function generateTestExperimentMetadata({
  control = 100,
  treatment = 0,
  uuid,
}: GenerateTestExperimentMetadataOpts): ExperimentMetadata {
  return {
    groups: [
      {
        value: ExperimentGroup.Control,
        weight: control,
      },
      {
        value: ExperimentGroup.Treatment,
        weight: treatment,
      },
    ],
    name: 'mobile_web_experiment_1',
    type: 'device_id',
    uuid,
    version: 1,
  };
}

export function mockExperimentGroupsForUser(
  experimentSlots: ExperimentSlots,
): ExperimentGroupsForUser {
  return Object.values(experimentSlots).reduce<{
    [key: string]: UserExperimentMetadata;
  }>((acc, experiment) => {
    if (experiment) {
      acc[experiment] = {
        group: ExperimentGroup.Control,
        name: 'mobile_web_experiment_1',
        type: 'device_id',
        uuid: experiment,
        version: 1,
      };
    }
    return acc;
  }, {});
}
