/* eslint-disable no-console */

// istanbul ignore next: trivial
export function printInvalidOverridesWarning(
  invalidOverrides: string[],
  experimentOverridesQuery: string[] | string,
): void {
  console.log(`

***********************************************************
*                                                         *
* WARNING: The following experiment overrides are         *
* invalid:                                                *
*                                                         *
${invalidOverrides.map((override) => `* - ${override}`).join('\n')}
*                                                         *
* The expected format is a comma seperated list of        *
* uuid=group pairs (e.g.                                  *
* "12345678-1234-1234-1234-123456789012=treatment,uuid2=control").
*                                                         *
* The full query parameter was:                           *
*                                                         *
* - ${experimentOverridesQuery}
***********************************************************

`);
}

// istanbul ignore next: trivial
export function printNotTreatmentAndControlWarning(uuid: string): void {
  console.warn(`

***********************************************************
*                                                         *
* WARNING: The following experiment has invalid group     *
* values:                                                 *
* - ${uuid}
*                                                         *
* As a result, the Tachyon platform will treat this       *
* experiment as 100% Control.                             *
*                                                         *
* Experiments must have exactly 2 groups, one with a      *
* 'value' of 'treatment' and  the other 'control'.        *
***********************************************************

`);
}

// istanbul ignore next: trivial
export function printInvalidSplitWarning(uuid: string): void {
  console.warn(`

***********************************************************
*                                                         *
* WARNING: The following experiment has invalid weight    *
* values:                                                 *
* - ${uuid}
*                                                         *
* As a result, the Tachyon platform will treat this       *
* experiment as 100% Control.                             *
*                                                         *
* Experiments may be weighted 0/100, 50/50 or 100/0. Any  *
* other 'weight' combinations will be treated as 50/50.   *
***********************************************************

`);
}

// istanbul ignore next: trivial
export function printAllTreatmentExperimentWarning(uuid: string): void {
  console.warn(`

***********************************************************
*                                                         *
* WARNING: The following experiment is at 100% treatment: *
* - ${uuid}
*                                                         *
* As a result, the Tachyon platform will treat this       *
* experiment as 100% Control when 'debug' is set.         *
*                                                         *
* Fully promoting an experiment should be done via code   *
* removal.                                                *
***********************************************************

`);
}

// istanbul ignore next: trivial
export function printExperimentNotFoundWarning(uuid: string): void {
  console.warn(`

***********************************************************
*                                                         *
* WARNING: The following experiment was not found:        *
* - ${uuid}
*                                                         *
* As a result, the Tachyon platform will treat this       *
* experiment as 100% Control.                             *
*
* Check that the correct UUID was used for the experiment *
* slot. Read the Tachyon Experiment docs for more info on *
* working with Minixperiment.                             *
***********************************************************

`);
}
