import type { FormatData } from 'twitch-intl';

/**
 * Converts a locale from "fr-FR" => "fr-fr" to match our Twitch Custom CLDR
 * locale file name format.
 */
export function convertLocaleToCLDRFileNameFormat(locale: string): string {
  return locale.toLowerCase();
}

/**
 * Loads custom Twitch CLDR rules for a given locale. Currently, the sole use
 * case for these is to enable the use of `formatNumberShort` on TachyonIntl.
 */
export function loadCLDRForLocale(locale: string): FormatData {
  const localeFileName = convertLocaleToCLDRFileNameFormat(locale);
  // eslint-disable-next-line @typescript-eslint/no-var-requires
  const numberShort = require(`custom-cldr-rules-twitch/dist/locale-data/number-short/${localeFileName}.json`);

  return {
    numberShort,
  };
}
