import { convertLocaleToCLDRFileNameFormat, loadCLDRForLocale } from '.';

describe('CLDR loading', () => {
  describe(convertLocaleToCLDRFileNameFormat, () => {
    it('converts locales', () => {
      expect(convertLocaleToCLDRFileNameFormat('fr-FR')).toEqual('fr-fr');
    });
  });

  describe(loadCLDRForLocale, () => {
    it('returns CLDR rules for a supported locale', () => {
      /* eslint-disable no-irregular-whitespace */
      /* eslint-disable-next-line jest/no-large-snapshots */
      expect(loadCLDRForLocale('fr-FR')).toMatchInlineSnapshot(`
Object {
  "numberShort": Object {
    "1000-count-one": "0 k",
    "1000-count-other": "0 k",
    "10000-count-one": "00 k",
    "10000-count-other": "00 k",
    "100000-count-one": "000 k",
    "100000-count-other": "000 k",
    "1000000-count-one": "0 M",
    "1000000-count-other": "0 M",
    "10000000-count-one": "00 M",
    "10000000-count-other": "00 M",
    "100000000-count-one": "000 M",
    "100000000-count-other": "000 M",
    "1000000000-count-one": "0 Md",
    "1000000000-count-other": "0 Md",
    "10000000000-count-one": "00 Md",
    "10000000000-count-other": "00 Md",
  },
}
`);
      /* eslint-enable no-irregular-whitespace */
    });

    it('throws an error when attempting to load CLDR rules for an unsupported locale', () => {
      expect(() => loadCLDRForLocale('some-locale')).toThrow();
    });
  });
});
