import { loadFormatDataHydrationScriptsForLocale } from '.';

describe(loadFormatDataHydrationScriptsForLocale, () => {
  beforeAll(() => {
    (window as any).IntlMessageFormat = { __addLocaleData: () => undefined };
    (window as any).IntlRelativeFormat = { __addLocaleData: () => undefined };
  });

  afterAll(() => {
    delete (window as any).IntlMessageFormat;
    delete (window as any).IntlRelativeFormat;
  });

  it('return scripts for a supported locale', async () => {
    const scripts = await loadFormatDataHydrationScriptsForLocale('en-US');
    expect(scripts).toHaveLength(2);
    // eslint-disable-next-line jest/no-large-snapshots
    expect(scripts).toMatchInlineSnapshot(`
      Array [
        "var e=IntlMessageFormat.__addLocaleData;e({locale:\\"en\\",pluralRuleFunction:function(e,n){var l=String(e).split(\\".\\"),a=!l[1],o=Number(l[0])==e,c=o&&l[0].slice(-1),t=o&&l[0].slice(-2);return n?1==c&&11!=t?\\"one\\":2==c&&12!=t?\\"two\\":3==c&&13!=t?\\"few\\":\\"other\\":1==e&&a?\\"one\\":\\"other\\"}}),e({locale:\\"en-001\\",parentLocale:\\"en\\"}),e({locale:\\"en-150\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-AG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-AI\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-AS\\",parentLocale:\\"en\\"}),e({locale:\\"en-AT\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-AU\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BB\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BE\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BI\\",parentLocale:\\"en\\"}),e({locale:\\"en-BM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BS\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BW\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-BZ\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CA\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CC\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CH\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-CK\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CX\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-CY\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-DE\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-DG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-DK\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-DM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-Dsrt\\",pluralRuleFunction:function(e,n){return\\"other\\"}}),e({locale:\\"en-ER\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-FI\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-FJ\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-FK\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-FM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GB\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GD\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GH\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GI\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-GU\\",parentLocale:\\"en\\"}),e({locale:\\"en-GY\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-HK\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-IE\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-IL\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-IM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-IN\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-IO\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-JE\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-JM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-KE\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-KI\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-KN\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-KY\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-LC\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-LR\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-LS\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MH\\",parentLocale:\\"en\\"}),e({locale:\\"en-MO\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MP\\",parentLocale:\\"en\\"}),e({locale:\\"en-MS\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MT\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MU\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MW\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-MY\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NA\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NF\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NL\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-NR\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NU\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-NZ\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-PG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-PH\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-PK\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-PN\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-PR\\",parentLocale:\\"en\\"}),e({locale:\\"en-PW\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-RW\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SB\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SC\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SD\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SE\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-SG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SH\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SI\\",parentLocale:\\"en-150\\"}),e({locale:\\"en-SL\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SS\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SX\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-SZ\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-Shaw\\",pluralRuleFunction:function(e,n){return\\"other\\"}}),e({locale:\\"en-TC\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-TK\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-TO\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-TT\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-TV\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-TZ\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-UG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-UM\\",parentLocale:\\"en\\"}),e({locale:\\"en-US\\",parentLocale:\\"en\\"}),e({locale:\\"en-VC\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-VG\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-VI\\",parentLocale:\\"en\\"}),e({locale:\\"en-VU\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-WS\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-ZA\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-ZM\\",parentLocale:\\"en-001\\"}),e({locale:\\"en-ZW\\",parentLocale:\\"en-001\\"});",
        "var e=IntlRelativeFormat.__addLocaleData;e({locale:\\"en\\",pluralRuleFunction:function(e,a){var t=String(e).split(\\".\\"),o=!t[1],r=Number(t[0])==e,n=r&&t[0].slice(-1),i=r&&t[0].slice(-2);return a?1==n&&11!=i?\\"one\\":2==n&&12!=i?\\"two\\":3==n&&13!=i?\\"few\\":\\"other\\":1==e&&o?\\"one\\":\\"other\\"},fields:{year:{displayName:\\"year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{one:\\"in {0} year\\",other:\\"in {0} years\\"},past:{one:\\"{0} year ago\\",other:\\"{0} years ago\\"}}},\\"year-short\\":{displayName:\\"yr.\\",relative:{0:\\"this yr.\\",1:\\"next yr.\\",\\"-1\\":\\"last yr.\\"},relativeTime:{future:{one:\\"in {0} yr.\\",other:\\"in {0} yr.\\"},past:{one:\\"{0} yr. ago\\",other:\\"{0} yr. ago\\"}}},month:{displayName:\\"month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{one:\\"in {0} month\\",other:\\"in {0} months\\"},past:{one:\\"{0} month ago\\",other:\\"{0} months ago\\"}}},\\"month-short\\":{displayName:\\"mo.\\",relative:{0:\\"this mo.\\",1:\\"next mo.\\",\\"-1\\":\\"last mo.\\"},relativeTime:{future:{one:\\"in {0} mo.\\",other:\\"in {0} mo.\\"},past:{one:\\"{0} mo. ago\\",other:\\"{0} mo. ago\\"}}},week:{displayName:\\"week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{one:\\"in {0} week\\",other:\\"in {0} weeks\\"},past:{one:\\"{0} week ago\\",other:\\"{0} weeks ago\\"}}},\\"week-short\\":{displayName:\\"wk.\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this wk.\\",1:\\"next wk.\\",\\"-1\\":\\"last wk.\\"},relativeTime:{future:{one:\\"in {0} wk.\\",other:\\"in {0} wk.\\"},past:{one:\\"{0} wk. ago\\",other:\\"{0} wk. ago\\"}}},day:{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},\\"day-short\\":{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},hour:{displayName:\\"hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hour\\",other:\\"in {0} hours\\"},past:{one:\\"{0} hour ago\\",other:\\"{0} hours ago\\"}}},\\"hour-short\\":{displayName:\\"hr.\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hr.\\",other:\\"in {0} hr.\\"},past:{one:\\"{0} hr. ago\\",other:\\"{0} hr. ago\\"}}},minute:{displayName:\\"minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} minute\\",other:\\"in {0} minutes\\"},past:{one:\\"{0} minute ago\\",other:\\"{0} minutes ago\\"}}},\\"minute-short\\":{displayName:\\"min.\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} min.\\",other:\\"in {0} min.\\"},past:{one:\\"{0} min. ago\\",other:\\"{0} min. ago\\"}}},second:{displayName:\\"second\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} second\\",other:\\"in {0} seconds\\"},past:{one:\\"{0} second ago\\",other:\\"{0} seconds ago\\"}}},\\"second-short\\":{displayName:\\"sec.\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} sec.\\",other:\\"in {0} sec.\\"},past:{one:\\"{0} sec. ago\\",other:\\"{0} sec. ago\\"}}}}},{locale:\\"en-001\\",parentLocale:\\"en\\",fields:{year:{displayName:\\"year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{one:\\"in {0} year\\",other:\\"in {0} years\\"},past:{one:\\"{0} year ago\\",other:\\"{0} years ago\\"}}},\\"year-short\\":{displayName:\\"yr\\",relative:{0:\\"this yr.\\",1:\\"next yr.\\",\\"-1\\":\\"last yr.\\"},relativeTime:{future:{one:\\"in {0} yr\\",other:\\"in {0} yr\\"},past:{one:\\"{0} yr ago\\",other:\\"{0} yr ago\\"}}},month:{displayName:\\"month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{one:\\"in {0} month\\",other:\\"in {0} months\\"},past:{one:\\"{0} month ago\\",other:\\"{0} months ago\\"}}},\\"month-short\\":{displayName:\\"mo\\",relative:{0:\\"this mo.\\",1:\\"next mo.\\",\\"-1\\":\\"last mo.\\"},relativeTime:{future:{one:\\"in {0} mo\\",other:\\"in {0} mo\\"},past:{one:\\"{0} mo ago\\",other:\\"{0} mo ago\\"}}},week:{displayName:\\"week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{one:\\"in {0} week\\",other:\\"in {0} weeks\\"},past:{one:\\"{0} week ago\\",other:\\"{0} weeks ago\\"}}},\\"week-short\\":{displayName:\\"wk\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this wk.\\",1:\\"next wk.\\",\\"-1\\":\\"last wk.\\"},relativeTime:{future:{one:\\"in {0} wk\\",other:\\"in {0} wk\\"},past:{one:\\"{0} wk ago\\",other:\\"{0} wk ago\\"}}},day:{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},\\"day-short\\":{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},hour:{displayName:\\"hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hour\\",other:\\"in {0} hours\\"},past:{one:\\"{0} hour ago\\",other:\\"{0} hours ago\\"}}},\\"hour-short\\":{displayName:\\"hr\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hr\\",other:\\"in {0} hr\\"},past:{one:\\"{0} hr ago\\",other:\\"{0} hr ago\\"}}},minute:{displayName:\\"minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} minute\\",other:\\"in {0} minutes\\"},past:{one:\\"{0} minute ago\\",other:\\"{0} minutes ago\\"}}},\\"minute-short\\":{displayName:\\"min\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} min\\",other:\\"in {0} min\\"},past:{one:\\"{0} min ago\\",other:\\"{0} min ago\\"}}},second:{displayName:\\"second\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} second\\",other:\\"in {0} seconds\\"},past:{one:\\"{0} second ago\\",other:\\"{0} seconds ago\\"}}},\\"second-short\\":{displayName:\\"sec\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} sec\\",other:\\"in {0} sec\\"},past:{one:\\"{0} sec ago\\",other:\\"{0} sec ago\\"}}}}},{locale:\\"en-150\\",parentLocale:\\"en-001\\"},{locale:\\"en-AG\\",parentLocale:\\"en-001\\"},{locale:\\"en-AI\\",parentLocale:\\"en-001\\"},{locale:\\"en-AS\\",parentLocale:\\"en\\"},{locale:\\"en-AT\\",parentLocale:\\"en-150\\"},{locale:\\"en-AU\\",parentLocale:\\"en-001\\",fields:{year:{displayName:\\"year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{one:\\"in {0} year\\",other:\\"in {0} years\\"},past:{one:\\"{0} year ago\\",other:\\"{0} years ago\\"}}},\\"year-short\\":{displayName:\\"yr\\",relative:{0:\\"this yr.\\",1:\\"next yr.\\",\\"-1\\":\\"last yr.\\"},relativeTime:{future:{one:\\"in {0} yr\\",other:\\"in {0} yrs\\"},past:{one:\\"{0} yr ago\\",other:\\"{0} yrs ago\\"}}},month:{displayName:\\"month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{one:\\"in {0} month\\",other:\\"in {0} months\\"},past:{one:\\"{0} month ago\\",other:\\"{0} months ago\\"}}},\\"month-short\\":{displayName:\\"mo.\\",relative:{0:\\"this mo.\\",1:\\"next mo.\\",\\"-1\\":\\"last mo.\\"},relativeTime:{future:{one:\\"in {0} mo.\\",other:\\"in {0} mo.\\"},past:{one:\\"{0} mo. ago\\",other:\\"{0} mo. ago\\"}}},week:{displayName:\\"week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{one:\\"in {0} week\\",other:\\"in {0} weeks\\"},past:{one:\\"{0} week ago\\",other:\\"{0} weeks ago\\"}}},\\"week-short\\":{displayName:\\"wk\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this wk.\\",1:\\"next wk.\\",\\"-1\\":\\"last wk.\\"},relativeTime:{future:{one:\\"in {0} wk\\",other:\\"in {0} wks\\"},past:{one:\\"{0} wk ago\\",other:\\"{0} wks ago\\"}}},day:{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},\\"day-short\\":{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},hour:{displayName:\\"hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hour\\",other:\\"in {0} hours\\"},past:{one:\\"{0} hour ago\\",other:\\"{0} hours ago\\"}}},\\"hour-short\\":{displayName:\\"h\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hr\\",other:\\"in {0} hrs\\"},past:{one:\\"{0} hr ago\\",other:\\"{0} hrs ago\\"}}},minute:{displayName:\\"minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} minute\\",other:\\"in {0} minutes\\"},past:{one:\\"{0} minute ago\\",other:\\"{0} minutes ago\\"}}},\\"minute-short\\":{displayName:\\"min.\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} min.\\",other:\\"in {0} mins\\"},past:{one:\\"{0} min. ago\\",other:\\"{0} mins ago\\"}}},second:{displayName:\\"second\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} second\\",other:\\"in {0} seconds\\"},past:{one:\\"{0} second ago\\",other:\\"{0} seconds ago\\"}}},\\"second-short\\":{displayName:\\"sec.\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} sec.\\",other:\\"in {0} secs\\"},past:{one:\\"{0} sec. ago\\",other:\\"{0} secs ago\\"}}}}},{locale:\\"en-BB\\",parentLocale:\\"en-001\\"},{locale:\\"en-BE\\",parentLocale:\\"en-001\\"},{locale:\\"en-BI\\",parentLocale:\\"en\\"},{locale:\\"en-BM\\",parentLocale:\\"en-001\\"},{locale:\\"en-BS\\",parentLocale:\\"en-001\\"},{locale:\\"en-BW\\",parentLocale:\\"en-001\\"},{locale:\\"en-BZ\\",parentLocale:\\"en-001\\"},{locale:\\"en-CA\\",parentLocale:\\"en-001\\",fields:{year:{displayName:\\"year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{one:\\"in {0} year\\",other:\\"in {0} years\\"},past:{one:\\"{0} year ago\\",other:\\"{0} years ago\\"}}},\\"year-short\\":{displayName:\\"yr.\\",relative:{0:\\"this yr.\\",1:\\"next yr.\\",\\"-1\\":\\"last yr.\\"},relativeTime:{future:{one:\\"in {0} yr.\\",other:\\"in {0} yrs.\\"},past:{one:\\"{0} yr. ago\\",other:\\"{0} yrs. ago\\"}}},month:{displayName:\\"month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{one:\\"in {0} month\\",other:\\"in {0} months\\"},past:{one:\\"{0} month ago\\",other:\\"{0} months ago\\"}}},\\"month-short\\":{displayName:\\"mo.\\",relative:{0:\\"this mo.\\",1:\\"next mo.\\",\\"-1\\":\\"last mo.\\"},relativeTime:{future:{one:\\"in {0} mo.\\",other:\\"in {0} mos.\\"},past:{one:\\"{0} mo. ago\\",other:\\"{0} mos. ago\\"}}},week:{displayName:\\"week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{one:\\"in {0} week\\",other:\\"in {0} weeks\\"},past:{one:\\"{0} week ago\\",other:\\"{0} weeks ago\\"}}},\\"week-short\\":{displayName:\\"wk.\\",relativePeriod:\\"the wk. of {0}\\",relative:{0:\\"this wk.\\",1:\\"next wk.\\",\\"-1\\":\\"last wk.\\"},relativeTime:{future:{one:\\"in {0} wk.\\",other:\\"in {0} wks.\\"},past:{one:\\"{0} wk. ago\\",other:\\"{0} wks. ago\\"}}},day:{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},\\"day-short\\":{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},hour:{displayName:\\"hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hour\\",other:\\"in {0} hours\\"},past:{one:\\"{0} hour ago\\",other:\\"{0} hours ago\\"}}},\\"hour-short\\":{displayName:\\"hr.\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hr.\\",other:\\"in {0} hrs.\\"},past:{one:\\"{0} hr. ago\\",other:\\"{0} hrs. ago\\"}}},minute:{displayName:\\"minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} minute\\",other:\\"in {0} minutes\\"},past:{one:\\"{0} minute ago\\",other:\\"{0} minutes ago\\"}}},\\"minute-short\\":{displayName:\\"min.\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} min.\\",other:\\"in {0} mins.\\"},past:{one:\\"{0} min. ago\\",other:\\"{0} mins. ago\\"}}},second:{displayName:\\"second\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} second\\",other:\\"in {0} seconds\\"},past:{one:\\"{0} second ago\\",other:\\"{0} seconds ago\\"}}},\\"second-short\\":{displayName:\\"sec.\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} sec.\\",other:\\"in {0} secs.\\"},past:{one:\\"{0} sec. ago\\",other:\\"{0} secs. ago\\"}}}}},{locale:\\"en-CC\\",parentLocale:\\"en-001\\"},{locale:\\"en-CH\\",parentLocale:\\"en-150\\"},{locale:\\"en-CK\\",parentLocale:\\"en-001\\"},{locale:\\"en-CM\\",parentLocale:\\"en-001\\"},{locale:\\"en-CX\\",parentLocale:\\"en-001\\"},{locale:\\"en-CY\\",parentLocale:\\"en-001\\"},{locale:\\"en-DE\\",parentLocale:\\"en-150\\"},{locale:\\"en-DG\\",parentLocale:\\"en-001\\"},{locale:\\"en-DK\\",parentLocale:\\"en-150\\"},{locale:\\"en-DM\\",parentLocale:\\"en-001\\"},{locale:\\"en-Dsrt\\",pluralRuleFunction:function(e){return\\"other\\"},fields:{year:{displayName:\\"Year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{other:\\"+{0} y\\"},past:{other:\\"-{0} y\\"}}},\\"year-short\\":{displayName:\\"Year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{other:\\"+{0} y\\"},past:{other:\\"-{0} y\\"}}},month:{displayName:\\"Month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{other:\\"+{0} m\\"},past:{other:\\"-{0} m\\"}}},\\"month-short\\":{displayName:\\"Month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{other:\\"+{0} m\\"},past:{other:\\"-{0} m\\"}}},week:{displayName:\\"Week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{other:\\"+{0} w\\"},past:{other:\\"-{0} w\\"}}},\\"week-short\\":{displayName:\\"Week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{other:\\"+{0} w\\"},past:{other:\\"-{0} w\\"}}},day:{displayName:\\"Day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{other:\\"+{0} d\\"},past:{other:\\"-{0} d\\"}}},\\"day-short\\":{displayName:\\"Day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{other:\\"+{0} d\\"},past:{other:\\"-{0} d\\"}}},hour:{displayName:\\"Hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{other:\\"+{0} h\\"},past:{other:\\"-{0} h\\"}}},\\"hour-short\\":{displayName:\\"Hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{other:\\"+{0} h\\"},past:{other:\\"-{0} h\\"}}},minute:{displayName:\\"Minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{other:\\"+{0} min\\"},past:{other:\\"-{0} min\\"}}},\\"minute-short\\":{displayName:\\"Minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{other:\\"+{0} min\\"},past:{other:\\"-{0} min\\"}}},second:{displayName:\\"Second\\",relative:{0:\\"now\\"},relativeTime:{future:{other:\\"+{0} s\\"},past:{other:\\"-{0} s\\"}}},\\"second-short\\":{displayName:\\"Second\\",relative:{0:\\"now\\"},relativeTime:{future:{other:\\"+{0} s\\"},past:{other:\\"-{0} s\\"}}}}},{locale:\\"en-ER\\",parentLocale:\\"en-001\\"},{locale:\\"en-FI\\",parentLocale:\\"en-150\\"},{locale:\\"en-FJ\\",parentLocale:\\"en-001\\"},{locale:\\"en-FK\\",parentLocale:\\"en-001\\"},{locale:\\"en-FM\\",parentLocale:\\"en-001\\"},{locale:\\"en-GB\\",parentLocale:\\"en-001\\"},{locale:\\"en-GD\\",parentLocale:\\"en-001\\"},{locale:\\"en-GG\\",parentLocale:\\"en-001\\"},{locale:\\"en-GH\\",parentLocale:\\"en-001\\"},{locale:\\"en-GI\\",parentLocale:\\"en-001\\"},{locale:\\"en-GM\\",parentLocale:\\"en-001\\"},{locale:\\"en-GU\\",parentLocale:\\"en\\"},{locale:\\"en-GY\\",parentLocale:\\"en-001\\"},{locale:\\"en-HK\\",parentLocale:\\"en-001\\"},{locale:\\"en-IE\\",parentLocale:\\"en-001\\"},{locale:\\"en-IL\\",parentLocale:\\"en-001\\"},{locale:\\"en-IM\\",parentLocale:\\"en-001\\"},{locale:\\"en-IN\\",parentLocale:\\"en-001\\"},{locale:\\"en-IO\\",parentLocale:\\"en-001\\"},{locale:\\"en-JE\\",parentLocale:\\"en-001\\"},{locale:\\"en-JM\\",parentLocale:\\"en-001\\"},{locale:\\"en-KE\\",parentLocale:\\"en-001\\"},{locale:\\"en-KI\\",parentLocale:\\"en-001\\"},{locale:\\"en-KN\\",parentLocale:\\"en-001\\"},{locale:\\"en-KY\\",parentLocale:\\"en-001\\"},{locale:\\"en-LC\\",parentLocale:\\"en-001\\"},{locale:\\"en-LR\\",parentLocale:\\"en-001\\"},{locale:\\"en-LS\\",parentLocale:\\"en-001\\"},{locale:\\"en-MG\\",parentLocale:\\"en-001\\"},{locale:\\"en-MH\\",parentLocale:\\"en\\"},{locale:\\"en-MO\\",parentLocale:\\"en-001\\"},{locale:\\"en-MP\\",parentLocale:\\"en\\"},{locale:\\"en-MS\\",parentLocale:\\"en-001\\"},{locale:\\"en-MT\\",parentLocale:\\"en-001\\"},{locale:\\"en-MU\\",parentLocale:\\"en-001\\"},{locale:\\"en-MW\\",parentLocale:\\"en-001\\"},{locale:\\"en-MY\\",parentLocale:\\"en-001\\"},{locale:\\"en-NA\\",parentLocale:\\"en-001\\"},{locale:\\"en-NF\\",parentLocale:\\"en-001\\"},{locale:\\"en-NG\\",parentLocale:\\"en-001\\"},{locale:\\"en-NL\\",parentLocale:\\"en-150\\"},{locale:\\"en-NR\\",parentLocale:\\"en-001\\"},{locale:\\"en-NU\\",parentLocale:\\"en-001\\"},{locale:\\"en-NZ\\",parentLocale:\\"en-001\\"},{locale:\\"en-PG\\",parentLocale:\\"en-001\\"},{locale:\\"en-PH\\",parentLocale:\\"en-001\\"},{locale:\\"en-PK\\",parentLocale:\\"en-001\\"},{locale:\\"en-PN\\",parentLocale:\\"en-001\\"},{locale:\\"en-PR\\",parentLocale:\\"en\\"},{locale:\\"en-PW\\",parentLocale:\\"en-001\\"},{locale:\\"en-RW\\",parentLocale:\\"en-001\\"},{locale:\\"en-SB\\",parentLocale:\\"en-001\\"},{locale:\\"en-SC\\",parentLocale:\\"en-001\\"},{locale:\\"en-SD\\",parentLocale:\\"en-001\\"},{locale:\\"en-SE\\",parentLocale:\\"en-150\\"},{locale:\\"en-SG\\",parentLocale:\\"en-001\\",fields:{year:{displayName:\\"year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{one:\\"in {0} year\\",other:\\"in {0} years\\"},past:{one:\\"{0} year ago\\",other:\\"{0} years ago\\"}}},\\"year-short\\":{displayName:\\"yr\\",relative:{0:\\"this yr\\",1:\\"next yr\\",\\"-1\\":\\"last yr\\"},relativeTime:{future:{one:\\"in {0} yr\\",other:\\"in {0} yr\\"},past:{one:\\"{0} yr ago\\",other:\\"{0} yr ago\\"}}},month:{displayName:\\"month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{one:\\"in {0} month\\",other:\\"in {0} months\\"},past:{one:\\"{0} month ago\\",other:\\"{0} months ago\\"}}},\\"month-short\\":{displayName:\\"mth\\",relative:{0:\\"this mth\\",1:\\"next mth\\",\\"-1\\":\\"last mth\\"},relativeTime:{future:{one:\\"in {0} mth\\",other:\\"in {0} mth\\"},past:{one:\\"{0} mth ago\\",other:\\"{0} mth ago\\"}}},week:{displayName:\\"week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{one:\\"in {0} week\\",other:\\"in {0} weeks\\"},past:{one:\\"{0} week ago\\",other:\\"{0} weeks ago\\"}}},\\"week-short\\":{displayName:\\"wk\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this wk\\",1:\\"next wk\\",\\"-1\\":\\"last wk\\"},relativeTime:{future:{one:\\"in {0} wk\\",other:\\"in {0} wk\\"},past:{one:\\"{0} wk ago\\",other:\\"{0} wk ago\\"}}},day:{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},\\"day-short\\":{displayName:\\"day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{one:\\"in {0} day\\",other:\\"in {0} days\\"},past:{one:\\"{0} day ago\\",other:\\"{0} days ago\\"}}},hour:{displayName:\\"hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hour\\",other:\\"in {0} hours\\"},past:{one:\\"{0} hour ago\\",other:\\"{0} hours ago\\"}}},\\"hour-short\\":{displayName:\\"hr\\",relative:{0:\\"this hour\\"},relativeTime:{future:{one:\\"in {0} hr\\",other:\\"in {0} hr\\"},past:{one:\\"{0} hr ago\\",other:\\"{0} hr ago\\"}}},minute:{displayName:\\"minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} minute\\",other:\\"in {0} minutes\\"},past:{one:\\"{0} minute ago\\",other:\\"{0} minutes ago\\"}}},\\"minute-short\\":{displayName:\\"min\\",relative:{0:\\"this minute\\"},relativeTime:{future:{one:\\"in {0} min\\",other:\\"in {0} min\\"},past:{one:\\"{0} min ago\\",other:\\"{0} min ago\\"}}},second:{displayName:\\"second\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} second\\",other:\\"in {0} seconds\\"},past:{one:\\"{0} second ago\\",other:\\"{0} seconds ago\\"}}},\\"second-short\\":{displayName:\\"sec\\",relative:{0:\\"now\\"},relativeTime:{future:{one:\\"in {0} sec\\",other:\\"in {0} sec\\"},past:{one:\\"{0} sec ago\\",other:\\"{0} sec ago\\"}}}}},{locale:\\"en-SH\\",parentLocale:\\"en-001\\"},{locale:\\"en-SI\\",parentLocale:\\"en-150\\"},{locale:\\"en-SL\\",parentLocale:\\"en-001\\"},{locale:\\"en-SS\\",parentLocale:\\"en-001\\"},{locale:\\"en-SX\\",parentLocale:\\"en-001\\"},{locale:\\"en-SZ\\",parentLocale:\\"en-001\\"},{locale:\\"en-Shaw\\",pluralRuleFunction:function(e){return\\"other\\"},fields:{year:{displayName:\\"Year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{other:\\"+{0} y\\"},past:{other:\\"-{0} y\\"}}},\\"year-short\\":{displayName:\\"Year\\",relative:{0:\\"this year\\",1:\\"next year\\",\\"-1\\":\\"last year\\"},relativeTime:{future:{other:\\"+{0} y\\"},past:{other:\\"-{0} y\\"}}},month:{displayName:\\"Month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{other:\\"+{0} m\\"},past:{other:\\"-{0} m\\"}}},\\"month-short\\":{displayName:\\"Month\\",relative:{0:\\"this month\\",1:\\"next month\\",\\"-1\\":\\"last month\\"},relativeTime:{future:{other:\\"+{0} m\\"},past:{other:\\"-{0} m\\"}}},week:{displayName:\\"Week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{other:\\"+{0} w\\"},past:{other:\\"-{0} w\\"}}},\\"week-short\\":{displayName:\\"Week\\",relativePeriod:\\"the week of {0}\\",relative:{0:\\"this week\\",1:\\"next week\\",\\"-1\\":\\"last week\\"},relativeTime:{future:{other:\\"+{0} w\\"},past:{other:\\"-{0} w\\"}}},day:{displayName:\\"Day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{other:\\"+{0} d\\"},past:{other:\\"-{0} d\\"}}},\\"day-short\\":{displayName:\\"Day\\",relative:{0:\\"today\\",1:\\"tomorrow\\",\\"-1\\":\\"yesterday\\"},relativeTime:{future:{other:\\"+{0} d\\"},past:{other:\\"-{0} d\\"}}},hour:{displayName:\\"Hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{other:\\"+{0} h\\"},past:{other:\\"-{0} h\\"}}},\\"hour-short\\":{displayName:\\"Hour\\",relative:{0:\\"this hour\\"},relativeTime:{future:{other:\\"+{0} h\\"},past:{other:\\"-{0} h\\"}}},minute:{displayName:\\"Minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{other:\\"+{0} min\\"},past:{other:\\"-{0} min\\"}}},\\"minute-short\\":{displayName:\\"Minute\\",relative:{0:\\"this minute\\"},relativeTime:{future:{other:\\"+{0} min\\"},past:{other:\\"-{0} min\\"}}},second:{displayName:\\"Second\\",relative:{0:\\"now\\"},relativeTime:{future:{other:\\"+{0} s\\"},past:{other:\\"-{0} s\\"}}},\\"second-short\\":{displayName:\\"Second\\",relative:{0:\\"now\\"},relativeTime:{future:{other:\\"+{0} s\\"},past:{other:\\"-{0} s\\"}}}}},{locale:\\"en-TC\\",parentLocale:\\"en-001\\"},{locale:\\"en-TK\\",parentLocale:\\"en-001\\"},{locale:\\"en-TO\\",parentLocale:\\"en-001\\"},{locale:\\"en-TT\\",parentLocale:\\"en-001\\"},{locale:\\"en-TV\\",parentLocale:\\"en-001\\"},{locale:\\"en-TZ\\",parentLocale:\\"en-001\\"},{locale:\\"en-UG\\",parentLocale:\\"en-001\\"},{locale:\\"en-UM\\",parentLocale:\\"en\\"},{locale:\\"en-US\\",parentLocale:\\"en\\"},{locale:\\"en-VC\\",parentLocale:\\"en-001\\"},{locale:\\"en-VG\\",parentLocale:\\"en-001\\"},{locale:\\"en-VI\\",parentLocale:\\"en\\"},{locale:\\"en-VU\\",parentLocale:\\"en-001\\"},{locale:\\"en-WS\\",parentLocale:\\"en-001\\"},{locale:\\"en-ZA\\",parentLocale:\\"en-001\\"},{locale:\\"en-ZM\\",parentLocale:\\"en-001\\"},{locale:\\"en-ZW\\",parentLocale:\\"en-001\\"});",
      ]
    `);
  });

  describe('special cases', () => {
    it('loads relative format for nb when given no', async () => {
      const scripts = await loadFormatDataHydrationScriptsForLocale('nb-NO');
      expect(scripts).toHaveLength(2);
      // eslint-disable-next-line jest/no-large-snapshots
      expect(scripts).toMatchInlineSnapshot(`
        Array [
          "var a=IntlMessageFormat.__addLocaleData;a({locale:\\"nb\\",pluralRuleFunction:function(a,e){return e?\\"other\\":1==a?\\"one\\":\\"other\\"}}),a({locale:\\"nb-SJ\\",parentLocale:\\"nb\\"});",
          "var e=IntlRelativeFormat.__addLocaleData;e({locale:\\"nb\\",pluralRuleFunction:function(e,r){return r?\\"other\\":1==e?\\"one\\":\\"other\\"},fields:{year:{displayName:\\"år\\",relative:{0:\\"i år\\",1:\\"neste år\\",\\"-1\\":\\"i fjor\\"},relativeTime:{future:{one:\\"om {0} år\\",other:\\"om {0} år\\"},past:{one:\\"for {0} år siden\\",other:\\"for {0} år siden\\"}}},\\"year-short\\":{displayName:\\"år\\",relative:{0:\\"i år\\",1:\\"neste år\\",\\"-1\\":\\"i fjor\\"},relativeTime:{future:{one:\\"om {0} år\\",other:\\"om {0} år\\"},past:{one:\\"for {0} år siden\\",other:\\"for {0} år siden\\"}}},month:{displayName:\\"måned\\",relative:{0:\\"denne måneden\\",1:\\"neste måned\\",\\"-1\\":\\"forrige måned\\"},relativeTime:{future:{one:\\"om {0} måned\\",other:\\"om {0} måneder\\"},past:{one:\\"for {0} måned siden\\",other:\\"for {0} måneder siden\\"}}},\\"month-short\\":{displayName:\\"mnd.\\",relative:{0:\\"denne md.\\",1:\\"neste md.\\",\\"-1\\":\\"forrige md.\\"},relativeTime:{future:{one:\\"om {0} md.\\",other:\\"om {0} md.\\"},past:{one:\\"for {0} md. siden\\",other:\\"for {0} md. siden\\"}}},week:{displayName:\\"uke\\",relativePeriod:\\"uken som inneholder {0}\\",relative:{0:\\"denne uken\\",1:\\"neste uke\\",\\"-1\\":\\"forrige uke\\"},relativeTime:{future:{one:\\"om {0} uke\\",other:\\"om {0} uker\\"},past:{one:\\"for {0} uke siden\\",other:\\"for {0} uker siden\\"}}},\\"week-short\\":{displayName:\\"uke\\",relativePeriod:\\"uken med {0}\\",relative:{0:\\"denne uken\\",1:\\"neste uke\\",\\"-1\\":\\"forrige uke\\"},relativeTime:{future:{one:\\"om {0} u.\\",other:\\"om {0} u.\\"},past:{one:\\"for {0} u. siden\\",other:\\"for {0} u. siden\\"}}},day:{displayName:\\"dag\\",relative:{0:\\"i dag\\",1:\\"i morgen\\",2:\\"i overmorgen\\",\\"-2\\":\\"i forgårs\\",\\"-1\\":\\"i går\\"},relativeTime:{future:{one:\\"om {0} døgn\\",other:\\"om {0} døgn\\"},past:{one:\\"for {0} døgn siden\\",other:\\"for {0} døgn siden\\"}}},\\"day-short\\":{displayName:\\"dag\\",relative:{0:\\"i dag\\",1:\\"i morgen\\",2:\\"i overmorgen\\",\\"-2\\":\\"i forgårs\\",\\"-1\\":\\"i går\\"},relativeTime:{future:{one:\\"om {0} d.\\",other:\\"om {0} d.\\"},past:{one:\\"for {0} d. siden\\",other:\\"for {0} d. siden\\"}}},hour:{displayName:\\"time\\",relative:{0:\\"denne timen\\"},relativeTime:{future:{one:\\"om {0} time\\",other:\\"om {0} timer\\"},past:{one:\\"for {0} time siden\\",other:\\"for {0} timer siden\\"}}},\\"hour-short\\":{displayName:\\"t\\",relative:{0:\\"denne timen\\"},relativeTime:{future:{one:\\"om {0} t\\",other:\\"om {0} t\\"},past:{one:\\"for {0} t siden\\",other:\\"for {0} t siden\\"}}},minute:{displayName:\\"minutt\\",relative:{0:\\"dette minuttet\\"},relativeTime:{future:{one:\\"om {0} minutt\\",other:\\"om {0} minutter\\"},past:{one:\\"for {0} minutt siden\\",other:\\"for {0} minutter siden\\"}}},\\"minute-short\\":{displayName:\\"min\\",relative:{0:\\"dette minuttet\\"},relativeTime:{future:{one:\\"om {0} min\\",other:\\"om {0} min\\"},past:{one:\\"for {0} min siden\\",other:\\"for {0} min siden\\"}}},second:{displayName:\\"sekund\\",relative:{0:\\"nå\\"},relativeTime:{future:{one:\\"om {0} sekund\\",other:\\"om {0} sekunder\\"},past:{one:\\"for {0} sekund siden\\",other:\\"for {0} sekunder siden\\"}}},\\"second-short\\":{displayName:\\"sek\\",relative:{0:\\"nå\\"},relativeTime:{future:{one:\\"om {0} sek\\",other:\\"om {0} sek\\"},past:{one:\\"for {0} sek siden\\",other:\\"for {0} sek siden\\"}}}}},{locale:\\"nb-SJ\\",parentLocale:\\"nb\\"});",
        ]
      `);
    });
  });
});
