import { clearIntlDataCache, prepareIntlDataCache } from '../intlDataCache';
import { selectIntlData } from '.';

jest.mock('tachyon-utils-stdlib', () => ({ isBrowser: () => false }));
jest.mock('tachyon-logger', () => ({ logger: { warn: jest.fn() } }));

describe(selectIntlData, () => {
  beforeEach(async () => {
    await prepareIntlDataCache();
  });

  afterEach(() => {
    clearIntlDataCache();
  });

  it('loads the default locale if none of the users preferred language codes are supported', () => {
    const selectedBundle = selectIntlData([
      'favorite-language',
      'second-favorite',
    ]);

    expect(selectedBundle.locales[0].default).toEqual(true);
  });

  it('loads the first supported locale in the list of language codes the user prefers', () => {
    const selectedBundle = selectIntlData([
      'favorite-language-code',
      'fr',
      'en',
    ]);

    expect(selectedBundle.locales[0].languageCode).toEqual('fr');
  });

  describe('when a user prefers a regional variant of a locale', () => {
    it('that variant is selected over the more general variant if we support it', () => {
      const selectedBundle = selectIntlData(['es-MX', 'es']);

      expect(selectedBundle.locales[0].locale).toEqual('es-MX');
    });

    it('falls through to the more general variant if we do not support the regional one', () => {
      const selectedBundle = selectIntlData(['es-NOPE', 'es']);

      // The browser will always send a general variant of a locale in the Accept-Language
      // headers (es for es-MX). TwitchIntl will match based on whatever similar
      // locale comes first in the list it is initialized with, in this case es-ES.
      expect(selectedBundle.locales[0].locale).toEqual('es-ES');
    });
  });
});
