import type { StaticLocale } from 'twitch-intl';

export function mockLocale(overrides?: Partial<StaticLocale>): StaticLocale {
  return {
    cldrLocale: 'zh-hans',
    data: {
      formatData: {
        numberShort: {
          '1000-count-one': '0 k',
          '1000-count-other': '0 k',
          '10000-count-one': '00 k',
          '10000-count-other': '00 k',
          '100000-count-one': '000 k',
          '100000-count-other': '000 k',
          '1000000-count-one': '0 M',
          '1000000-count-other': '0 M',
          '10000000-count-one': '00 M',
          '10000000-count-other': '00 M',
          '100000000-count-one': '000 M',
          '100000000-count-other': '000 M',
          '1000000000-count-one': '0 Md',
          '1000000000-count-other': '0 Md',
          '10000000000-count-one': '00 Md',
          '10000000000-count-other': '00 Md',
        },
      },
      locale: 'zh-CN',
      messages: {
        'message-key-1': 'I like turtles',
        'message-key-2': 'I prefer dogs',
        'message-key-3': 'I enjoy dolphins',
        'message-key-4': 'Elephants are neat as well',
      },
    },
    intlMessageFormatKey: 'zh',
    languageCode: 'zh-cn',
    locale: 'zh-CN',
    name: '中文 简体',
    ...overrides,
  };
}
