import type { TwitchIntl } from 'twitch-intl';

function formatMessage(message: string, opts?: Record<string, string>): string {
  if (opts) {
    Object.entries(opts).forEach(([k, v]) => {
      message = message.replace(`{${k}}`, v);
    });
  }

  return message;
}

function formatNumberShort(value: number): string {
  if (value > 1000000) {
    return `${Math.ceil(value / 1000000)}M`;
  }
  if (value > 1000) {
    return `${Math.ceil(value / 1000)}K`;
  }

  return value.toString();
}

function formatRelativeDate(date: Date): string {
  return `${date.valueOf()} milliseconds ago`;
}

export const DefaultTwitchIntl: TwitchIntl = {
  formatDate: (date: Date) =>
    date.toLocaleDateString('en-US', { timeZone: 'UTC' }),
  formatMessage,
  formatNumber: (value: number) => value.toString(),
  formatNumberShort,
  formatPastRelativeDate: formatRelativeDate,
  formatRelativeDate,
  formatTime: (time: Date) =>
    time.toLocaleTimeString('en-US', { timeZone: 'UTC' }),
  getActiveLocale: () => 'en-US',
  getLanguageCode: () => 'en',
  loadLocale: async () => undefined,
  loadLocaleSync: () => undefined,
  resolveLocaleFromCode: (_languageCode: string) => null,
} as any;
