import type { FC } from 'react';
import { useMemo } from 'react';
import { useIntl } from '../useIntl';
import type { CountryCode } from '../utils';
import { isCurrentUserCountrySupported } from '../utils';

export interface LocaleGateProps {
  blocklist?: boolean;
  countries: CountryCode[];
  fallback?: JSX.Element | (() => JSX.Element | null) | null;
}

export const LocaleGate: FC<LocaleGateProps> = ({
  blocklist = false,
  children,
  countries,
  fallback = null,
}) => {
  const { getActiveLocale } = useIntl();
  const currentLocale = getActiveLocale();
  const shouldRender = useMemo(
    () =>
      currentLocale === null
        ? false
        : blocklist !== isCurrentUserCountrySupported(currentLocale, countries),
    [countries, blocklist, currentLocale],
  );

  return (
    <>
      {shouldRender
        ? children
        : typeof fallback === 'function'
        ? fallback()
        : fallback}
    </>
  );
};

LocaleGate.displayName = 'LocaleGate';
