import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CountryCode } from '..';
import type { LocaleGateProps } from '.';
import { LocaleGate } from '.';

describe(LocaleGate, () => {
  const LocaleGateWithChildren: FC<LocaleGateProps> = (props) => (
    <LocaleGate {...props}>
      <div className="children" />
    </LocaleGate>
  );
  const setup = createMountWrapperFactory(LocaleGateWithChildren, () => ({
    countries: [CountryCode.UnitedStates],
  }));

  it('renders the children when country code matches', () => {
    const { wrapper } = setup();
    expect(wrapper.find('.children')).toHaveLength(1);
  });

  it('renders the default fallback when country code mismatches', () => {
    const { wrapper } = setup({ countries: [CountryCode.Mexico] });
    expect(wrapper.find('.children')).toHaveLength(0);
  });

  it('renders the children when country code does not match AND this is a blocklist', () => {
    const { wrapper } = setup({
      blocklist: true,
      countries: [CountryCode.Mexico],
    });
    expect(wrapper.find('.children')).toHaveLength(1);
  });

  it('renders the default fallback when country code matches AND this is a blocklist', () => {
    const { wrapper } = setup({ blocklist: true });
    expect(wrapper.find('.children')).toHaveLength(0);
  });

  it('renders the defined fallback when country code mismatches', () => {
    const { wrapper } = setup({
      countries: [CountryCode.Mexico],
      fallback: () => <div className="fallback" />,
    });
    expect(wrapper.find('.children')).toHaveLength(0);
    expect(wrapper.find('.fallback')).toHaveLength(1);
  });
});
