// eslint-disable-next-line tachyon/no-react-import
import React from 'react';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { TwitchIntl } from 'twitch-intl';
import { mockIntlData } from '../test-mocks';
import { TachyonIntlRoot, intlContext } from '.';

let mockIsBrowser = true;
jest.mock('tachyon-utils-stdlib', () => ({
  ...jest.requireActual('tachyon-utils-stdlib'),
  isBrowser: () => mockIsBrowser,
}));

describe(TachyonIntlRoot, () => {
  const setup = createShallowWrapperFactory(TachyonIntlRoot, () => ({
    data: {
      ...mockIntlData(),
      formatDataHydrationScripts: [
        'someFormatDataScript()',
        'anotherFormatDataScript()',
      ],
    },
  }));

  let evalMock: jest.Mock;
  let realEval: typeof global.eval;

  beforeEach(() => {
    evalMock = jest.fn();
    /* eslint-disable no-eval */
    realEval = global.eval;
    global.eval = evalMock;
  });

  afterAll(() => {
    global.eval = realEval;
    /* eslint-enable no-eval */
  });

  describe('passing in intlData', () => {
    it('initializes TwitchIntl with the expected locale and passes it the provider', () => {
      const { props, wrapper } = setup();
      const { intl } = wrapper.find(intlContext.Provider).prop('value');

      expect(intl).toBeInstanceOf(TwitchIntl);
      expect(intl.getLanguageCode()).toEqual(
        props.data!.preferredLanguageTags[0],
      );
    });

    it('evals format data scripts on the client', () => {
      mockIsBrowser = true;

      setup();
      expect(evalMock).toHaveBeenCalledWith(
        'someFormatDataScript();anotherFormatDataScript();',
      );
    });

    it('does not eval format data scripts on the server', () => {
      mockIsBrowser = false;

      setup();
      expect(evalMock).not.toHaveBeenCalled();
    });
  });

  describe('passing in TwitchIntl instance', () => {
    it('initializes TwitchIntl with the expected locale and passes it the provider', () => {
      const { props, wrapper } = setup({
        intl: new TwitchIntl([], React),
      });
      const { intl } = wrapper.find(intlContext.Provider).prop('value');

      expect(intl).toBe(props.intl);
    });
  });
});
